//Analysis of Symmetrical Fault in Power Systems//
//This program requires user input. A sample problem with user input and output is available in the result file
clc;
clear;
linedata=input('enter the line data values in the order of starting bus, Ending bus, resistance and reactance:')
f=input('enter the bus at wich fault occurs:')  
fi=input('Enter the fault impedance:')
bv=input('enter the pre-fault bus voltage:')  
sb=linedata(:,1)  //Starting bus number of all the lines
eb=linedata(:,2)  //Ending bus number of all the lines
z=linedata(:,3)+linedata(:,4)*%i  //line impedance, Z=R+jX
zbus=[];
check=[];
nb=max(max(sb),max(eb))
for i=1:length(sb)  //starting of impedance matrix calculation part//
    m=sb(i);
    n=eb(i);
    mn=min(m,n);
    nm=max(m,n);
    ncheck=length(find(check==nm));
    mcheck=length(find(check==mn));
    [rows columns]=size(zbus);
    if mn==0 & ncheck==0 
        zbus=[zbus zeros(rows,1);zeros(1,rows) z(i)];
        check=[check nm];
         else if mcheck>0 & ncheck==0
            zbus=[zbus zbus(:,mn);zbus(mn,:) zbus(mn,mn)+z(i)];
            check=[check nm];
            elseif mn==0 & ncheck>0
            zbus=[zbus zbus(:,nm);zbus(nm,:) zbus(nm,nm)+z(i)];
            zbusn=zeros(rows,rows);
            for r=1:rows
                for t=1:columns
                    zbusn(r,t)=zbus(r,t)-(zbus(r,rows+1)*zbus(rows+1,t))/(zbus(rows+1,rows+1));
                end
            end
            zbus=zbusn
        elseif mcheck>0 & ncheck>0
            zbus=[zbus zbus(:,nm)-zbus(:,mn);zbus(nm,:)-zbus(mn,:),z(i)+zbus(mn,nm)+zbus(nm,nm)-2*zbus(nm,mn)];
            zbusn=zeros(rows,rows);
            for r=1:rows
                for t=1:columns
                   zbusn(r,t)=zbus(r,t)-(zbus(r,rows+1)*zbus(rows+1,t))/(zbus(rows+1,rows+1)); 
               end
           end
           zbus=zbusn;
       end
   end
end   //ending of impedance bus matrix calculation part// 
disp(zbus,'the impedance matrix is:');
ifa=bv/(zbus(f,f)+fi)  //calculation of fault current//
disp(ifa,'the fault current is:')
disp('Post fault voltages v1,v2,v3 respectively are:');
for i=1:nb
v(i)=bv-(ifa*zbus(i,f)); //calculation of post fault bus voltages//
disp(v(i));
end
a=input('enter the starting bus to calculate the line flow:');
b=input('enter the ending bus to calculate the line flow:');
zs=input('enter the impedance between the above buses:');
i13=(v(a)-v(b))/zs; //calculation of line flow current//
disp(i13,'the line flow current is:')

//SAMPLE INPUT and OUTPUT 
 
//enter the line data values in the order of starting bus, Ending bus, resistance and reactance:[1 0 0 0.1; 1 2 0 0.2; 2 0 0 0.1; 0 3 0 0.1; 3 1 0 0.1]
//enter the bus at wich fault occurs:1
//Enter the fault impedance:0.08*%i
//enter the pre-fault bus voltage:2
 
// the impedance matrix is:   
 
//    0.046875i    0.015625i    0.0375i  
//    0.015625i    0.071875i    0.0125i  
//    0.0375i      0.0125i      0.05i    
 
// the fault current is:   
 
//  - 15.763547i  
 
// Post fault voltages v1,v2,v3 respectively are:   
 
//    1.2610837  
 
//    1.7536946  
 
//    1.408867  
//enter the starting bus to calculate the line flow:1
//enter the ending bus to calculate the line flow:2
//enter the impedance between the above buses:0.2*%i
 
// the line flow current is:   
 
//    2.4630542i  
